/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.particles;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.CustomParticleEvent;
import noppes.npcs.api.handler.data.ICustomParticle;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;

public class CustomParticle
extends Particle
implements ICustomElement,
ICustomParticle {
    public NBTTagCompound nbtData;
    public ResourceLocation texture;
    public ResourceLocation obj;
    public boolean full = false;
    public int objList;
    protected float particleAngleX;
    protected float particleAngleZ;
    protected long rndStart;

    public CustomParticle(NBTTagCompound data, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.nbtData = data;
        this.objList = -1;
        this.rndStart = this.field_187136_p.nextInt(7000);
        if (data.func_150297_b("OBJModel", 8)) {
            this.obj = new ResourceLocation("customnpcs", "models/particle/" + data.func_74779_i("OBJModel") + ".obj");
        }
        if (data.func_150297_b("IsFullTexture", 1)) {
            this.full = data.func_74767_n("IsFullTexture");
        }
        if (data.func_150297_b("MaxAge", 3)) {
            this.field_70547_e = data.func_74762_e("MaxAge");
        }
        if (data.func_150297_b("Gravity", 5)) {
            this.field_70545_g = data.func_74760_g("Gravity");
        }
        if (data.func_150297_b("Scale", 5)) {
            this.field_70544_f = data.func_74760_g("Scale");
        }
        if (data.func_150297_b("Texture", 8)) {
            this.texture = new ResourceLocation("customnpcs", "textures/particle/" + data.func_74779_i("Texture") + ".png");
        }
        if (data.func_150297_b("UVpos", 11) && data.func_74759_k("UVpos").length > 1) {
            int[] p = data.func_74759_k("UVpos");
            for (int i = 0; i < 2; ++i) {
                if (p[i] < 0) {
                    p[i] = 0;
                    continue;
                }
                if (p[i] <= 15) continue;
                p[i] = 15;
            }
            this.func_70536_a(p[0] + p[1] * 16);
        }
        if (xSpeedIn == 0.0) {
            this.field_187129_i = 0.0;
        }
        if (ySpeedIn == 0.0) {
            this.field_187130_j = 0.0;
        }
        if (zSpeedIn == 0.0) {
            this.field_187131_k = 0.0;
        }
        if (data.func_150297_b("StartMotion", 9) && data.func_150295_c("StartMotion", 6).func_74745_c() > 2) {
            NBTTagList list = data.func_150295_c("StartMotion", 6);
            if (data.func_74767_n("IsRandomMotion")) {
                this.field_187129_i = (Math.random() < 0.5 ? -1.0 : 1.0) * Math.random() * list.func_150309_d(0);
                this.field_187130_j = (Math.random() < 0.5 && !data.func_74767_n("NotMotionY") ? -1.0 : 1.0) * Math.random() * list.func_150309_d(1);
                this.field_187131_k = (Math.random() < 0.5 ? -1.0 : 1.0) * Math.random() * list.func_150309_d(2);
            } else {
                this.field_187129_i = list.func_150309_d(0);
                this.field_187130_j = list.func_150309_d(1);
                this.field_187131_k = list.func_150309_d(2);
            }
        }
        CustomParticleEvent.CreateEvent event = new CustomParticleEvent.CreateEvent(this, Minecraft.func_71410_x().field_71439_g);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, "customParticleCreateEvent", (Event)event);
    }

    @Override
    public boolean canCollide() {
        return this.field_190017_n;
    }

    @Override
    public int getAge() {
        return this.field_70546_d;
    }

    public float getAlphaF() {
        return this.field_82339_as;
    }

    @Override
    public int getColorMask() {
        return (int)((float)(((int)(this.field_70552_h * 255.0f) << 16) + ((int)(this.field_70553_i * 255.0f) << 8)) + this.field_70551_j * 255.0f);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName").toLowerCase();
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    @Override
    public float getHeight() {
        return this.field_187135_o;
    }

    @Override
    public String getObj() {
        return this.obj.toString();
    }

    @Override
    public double[] getPrevPoses() {
        return new double[]{this.field_187123_c, this.field_187124_d, this.field_187125_e};
    }

    @Override
    public float getRotationX() {
        return this.field_190014_F;
    }

    @Override
    public float getRotationY() {
        return this.particleAngleX;
    }

    @Override
    public float getRotationZ() {
        return this.particleAngleZ;
    }

    @Override
    public float getScale() {
        return this.field_70544_f;
    }

    @Override
    public String getTexture() {
        return this.texture.toString();
    }

    @Override
    public int getTotalAge() {
        return this.field_70547_e;
    }

    @Override
    public float getWidth() {
        return this.field_187134_n;
    }

    @Override
    public IWorld getWorld() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIWorld(this.field_187122_b);
    }

    @Override
    public boolean onGround() {
        return this.field_187132_l;
    }

    public void func_189213_a() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        CustomParticleEvent.UpdateEvent event = new CustomParticleEvent.UpdateEvent(this, Minecraft.func_71410_x().field_71439_g);
        event.setCanceled(true);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, "customParticleUpdateEvent", (Event)event);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (!event.isCanceled()) {
            return;
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.98;
        this.field_187130_j *= 0.98;
        this.field_187131_k *= 0.98;
        if (this.field_187132_l) {
            this.field_187129_i *= 0.7;
            this.field_187131_k *= 0.7;
        }
        if (this.obj != null && !this.field_187132_l) {
            this.field_190014_F = (System.currentTimeMillis() + this.rndStart) / 7L % 360L;
            this.particleAngleX = (System.currentTimeMillis() + this.rndStart) / 7L % 360L;
        }
    }

    @Override
    public double posX() {
        return this.field_187126_f;
    }

    @Override
    public double posY() {
        return this.field_187127_g;
    }

    @Override
    public double posZ() {
        return this.field_187128_h;
    }

    public void func_180434_a(@Nonnull BufferBuilder buffer, @Nonnull Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        CustomParticleEvent.RenderEvent event = new CustomParticleEvent.RenderEvent(this, Minecraft.func_71410_x().field_71439_g);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, "customParticleRenderEvent", (Event)event);
        if (event.isCanceled()) {
            return;
        }
        try {
            if (this.obj != null) {
                if (!ClientGuiEventHandler.customParticle.contains(this)) {
                    ClientGuiEventHandler.customParticle.add(this);
                }
                return;
            }
            if (this.texture == null) {
                return;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            float f = (float)this.field_94054_b / 16.0f;
            float f1 = f + 0.0624375f;
            float f2 = (float)this.field_94055_c / 16.0f;
            float f3 = f2 + 0.0624375f;
            float f4 = 0.1f * this.field_70544_f;
            if (this.full) {
                f = 0.0f;
                f1 = 1.0f;
                f2 = 0.0f;
                f3 = 1.0f;
            }
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            int i = this.func_189214_a(partialTicks);
            int j = i >> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
            if (this.field_190014_F != 0.0f) {
                float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
                float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
                float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)CustomParticle.field_190016_K.field_72450_a;
                float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)CustomParticle.field_190016_K.field_72448_b;
                float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)CustomParticle.field_190016_K.field_72449_c;
                Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
                for (int l = 0; l < 4; ++l) {
                    avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
                }
            }
            buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void setAge(int ticks) {
        if (ticks < 0) {
            ticks = 0;
        }
        this.field_70546_d = ticks;
    }

    public void func_82338_g(float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        this.field_82339_as = alpha;
    }

    @Override
    public void setCanCollide(boolean collide) {
        this.field_190017_n = collide;
    }

    @Override
    public void setColorMask(int color) {
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
    }

    @Override
    public void setCustomSize(float width, float height) {
        this.func_187115_a(width, height);
    }

    @Override
    public void setObj(String objPath) {
        this.obj = new ResourceLocation(objPath);
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.func_187109_b(x, y, z);
    }

    @Override
    public void setRotation(float angleX, float angleY, float angleZ) {
        this.field_190014_F = angleY % 360.0f;
        this.particleAngleX = angleX % 360.0f;
        this.particleAngleZ = angleZ % 360.0f;
    }

    @Override
    public void setScale(float scale) {
        if (scale == 0.0f) {
            return;
        }
        this.field_70544_f = scale;
    }

    @Override
    public void setTexture(String texture) {
        this.texture = new ResourceLocation(texture);
    }

    @Override
    public void setTotalAge(int ticks) {
        if (ticks < 0) {
            ticks = 0;
        }
        this.field_70547_e = ticks;
    }

    @Override
    public int getType() {
        return this.obj != null ? 1 : 0;
    }
}

